"use strict";
const CHANNEL_GET_CONFIG = "llonebot_get_config";
const CHANNEL_SET_CONFIG = "llonebot_set_config";
const CHANNEL_LOG = "llonebot_log";
const CHANNEL_ERROR = "llonebot_error";
const CHANNEL_UPDATE = "llonebot_update";
const CHANNEL_CHECKVERSION = "llonebot_checkversion";
const CHANNEL_SELECT_FILE = "llonebot_select_ffmpeg";
const { contextBridge } = require("electron");
const { ipcRenderer } = require("electron");
const llonebot = {
  log: (data) => {
    ipcRenderer.send(CHANNEL_LOG, data);
  },
  checkVersion: async () => {
    return ipcRenderer.invoke(CHANNEL_CHECKVERSION);
  },
  updateLLOneBot: async () => {
    return ipcRenderer.invoke(CHANNEL_UPDATE);
  },
  setConfig: (config) => {
    ipcRenderer.send(CHANNEL_SET_CONFIG, config);
  },
  getConfig: async () => {
    return ipcRenderer.invoke(CHANNEL_GET_CONFIG);
  },
  getError: async () => {
    return ipcRenderer.invoke(CHANNEL_ERROR);
  },
  selectFile: () => {
    return ipcRenderer.invoke(CHANNEL_SELECT_FILE);
  }
};
contextBridge.exposeInMainWorld("llonebot", llonebot);
