const SettingList = (items, title, isCollapsible = false, direction = "column") => {
  return `<setting-section ${title && !isCollapsible ? `data-title="${title}"` : ""}>
    <setting-panel>
        <setting-list ${direction ? `data-direction="${direction}"` : ""} ${isCollapsible ? "is-collapsible" : ""} ${title && isCollapsible ? `data-title="${title}"` : ""}>
            ${items.join("")}
        </setting-list>
    </setting-panel>
</setting-section>`;
};
const SettingItem = (title, subtitle, action, id, visible = true) => {
  return `<setting-item ${id ? `id="${id}"` : ""} ${!visible ? "is-hidden" : ""}>
    <div>
        <setting-text>${title}</setting-text>
        ${subtitle ? `<setting-text data-type="secondary">${subtitle}</setting-text>` : ""}
    </div>
    ${action ? `<div>${action}</div>` : ""}
</setting-item>`;
};
const SettingButton = (text, id, type = "secondary") => {
  return `<setting-button ${type ? `data-type="${type}"` : ""} ${id ? `id="${id}"` : ""}>${text}</setting-button>`;
};
const SettingSwitch = (configKey, isActive = false, extraData) => {
  return `<setting-switch 
    ${configKey ? `data-config-key="${configKey}"` : ""} 
    ${isActive ? "is-active" : ""} 
    ${extraData ? Object.keys(extraData).map((key) => `data-${key}="${extraData[key]}"`) : ""} 
    >
</setting-switch>`;
};
const SettingOption = (text, value, isSelected = false) => {
  return `<setting-option ${value ? `data-value="${value}"` : ""} ${isSelected ? "is-selected" : ""}>${text}</setting-option>`;
};
const SettingSelect = (items, configKey, configValue) => {
  return `<setting-select ${configKey ? `data-config-key="${configKey}"` : ""}>
    <div>
        ${items.map((e, i) => {
    return SettingOption(e.text, e.value, configKey && configValue ? configValue === e.value : i === 0);
  }).join("")}
    </div>
</setting-select>`;
};
const StyleRaw = "setting-item[is-hidden],\nsetting-item[is-hidden] + setting-divider {\n  display: none !important;\n}\n\n.config-host-list {\n  width: 100%;\n  padding-left: 16px;\n  box-sizing: border-box;\n}\n.config-host-list[is-hidden],\n.config-host-list[is-hidden] + setting-divider {\n  display: none !important;\n}\n\nsetting-item .q-input {\n  height: 24px;\n  width: 100px;\n  border-top-left-radius: 4px;\n  border-top-right-radius: 4px;\n  border-bottom-right-radius: 4px;\n  border-bottom-left-radius: 4px;\n  box-sizing: border-box;\n  position: relative;\n  background: var(--bg_bottom_light);\n  border: 1px solid var(--border_dark);\n}\n\nsetting-item .q-input .q-input__inner {\n  border-top-left-radius: 4px;\n  border-top-right-radius: 4px;\n  border-bottom-right-radius: 4px;\n  border-bottom-left-radius: 4px;\n  box-sizing: border-box;\n  color: var(--text_primary);\n  font-family: inherit;\n  font-size: 12px;\n  height: 24px;\n  line-height: 24px;\n  width: 100%;\n  border: 1px solid transparent;\n  padding: 0px 8px;\n}\n\nsetting-item .q-input input[type=number].q-input__inner::-webkit-outer-spin-button,\nsetting-item .q-input input[type=number].q-input__inner::-webkit-inner-spin-button {\n  -webkit-appearance: none;\n  margin: 0;\n}\n\n.config-host-list setting-item.setting-host-list-item .q-input {\n  width: 260px;\n}\n\nsetting-item a {\n  color: var(--text-link);\n}\nsetting-item a:hover {\n  color: var(--hover-link);\n}\nsetting-item a:active,\nsetting-item a:visited {\n  color: var(--text-link);\n}";
async function onSettingWindowCreated(view) {
  window.llonebot.log("setting window created");
  const isEmpty = (value) => value === void 0 || value === null || value === "";
  let config = await window.llonebot.getConfig();
  let ob11Config = { ...config.ob11 };
  const setConfig = (key, value) => {
    const configKey = key.split(".");
    if (key.indexOf("ob11") === 0) {
      if (configKey.length === 2)
        ob11Config[configKey[1]] = value;
      else
        ob11Config[key] = value;
    } else {
      if (configKey.length === 2)
        config[configKey[0]][configKey[1]] = value;
      else
        config[key] = value;
      if (!["heartInterval", "token", "ffmpeg"].includes(key)) {
        window.llonebot.setConfig(config);
      }
    }
  };
  const parser = new DOMParser();
  const doc = parser.parseFromString([
    "<div>",
    `<style>${StyleRaw}</style>`,
    SettingList([
      SettingItem(
        "启用 HTTP 服务",
        null,
        SettingSwitch("ob11.enableHttp", config.ob11.enableHttp, { "control-display-id": "config-ob11-httpPort" })
      ),
      SettingItem(
        "HTTP 服务监听端口",
        null,
        `<div class="q-input"><input class="q-input__inner" data-config-key="ob11.httpPort" type="number" min="1" max="65534" value="${config.ob11.httpPort}" placeholder="${config.ob11.httpPort}" /></div>`,
        "config-ob11-httpPort",
        config.ob11.enableHttp
      ),
      SettingItem(
        "启用 HTTP 事件上报",
        null,
        SettingSwitch("ob11.enableHttpPost", config.ob11.enableHttpPost, { "control-display-id": "config-ob11-httpHosts" })
      ),
      `<div class="config-host-list" id="config-ob11-httpHosts" ${config.ob11.enableHttpPost ? "" : "is-hidden"}>
                <setting-item data-direction="row">
                    <div>
                        <setting-text>HTTP 事件上报地址</setting-text>
                    </div>
                    <setting-button id="config-ob11-httpHosts-add" data-type="primary">添加</setting-button>
                </setting-item>
                <div id="config-ob11-httpHosts-list"></div>
            </div>`,
      SettingItem(
        "启用正向 WebSocket 服务",
        null,
        SettingSwitch("ob11.enableWs", config.ob11.enableWs, { "control-display-id": "config-ob11-wsPort" })
      ),
      SettingItem(
        "正向 WebSocket 服务监听端口",
        null,
        `<div class="q-input"><input class="q-input__inner" data-config-key="ob11.wsPort" type="number" min="1" max="65534" value="${config.ob11.wsPort}" placeholder="${config.ob11.wsPort}" /></div>`,
        "config-ob11-wsPort",
        config.ob11.enableWs
      ),
      SettingItem(
        "启用反向 WebSocket 服务",
        null,
        SettingSwitch("ob11.enableWsReverse", config.ob11.enableWsReverse, { "control-display-id": "config-ob11-wsHosts" })
      ),
      `<div class="config-host-list" id="config-ob11-wsHosts" ${config.ob11.enableWsReverse ? "" : "is-hidden"}>
                <setting-item data-direction="row">
                    <div>
                        <setting-text>反向 WebSocket 监听地址</setting-text>
                    </div>
                    <setting-button id="config-ob11-wsHosts-add" data-type="primary">添加</setting-button>
                </setting-item>
                <div id="config-ob11-wsHosts-list"></div>
            </div>`,
      SettingItem(
        " WebSocket 服务心跳间隔",
        "控制每隔多久发送一个心跳包，单位为毫秒",
        `<div class="q-input"><input class="q-input__inner" data-config-key="heartInterval" type="number" min="1000" value="${config.heartInterval}" placeholder="${config.heartInterval}" /></div>`
      ),
      SettingItem(
        "Access token",
        null,
        `<div class="q-input" style="width:210px;"><input class="q-input__inner" data-config-key="token" type="text" value="${config.token}" placeholder="未设置" /></div>`
      ),
      SettingItem(
        "消息上报格式类型",
        `如客户端无特殊需求推荐保持默认设置，两者的详细差异可参考 <a href="javascript:LiteLoader.api.openExternal('https://github.com/botuniverse/onebot-11/tree/master/message#readme');">OneBot v11 文档</a>`,
        SettingSelect([
          { text: "消息段", value: "array" },
          { text: "CQ码", value: "string" }
        ], "ob11.messagePostFormat", config.ob11.messagePostFormat)
      ),
      SettingItem(
        "ffmpeg 路径，发送语音、视频需要，同时保证ffprobe和ffmpeg在一起",
        ` <a href="javascript:LiteLoader.api.openExternal('https://llonebot.github.io/zh-CN/guide/ffmpeg');">下载地址</a> <span id="config-ffmpeg-path-text">, 路径:${!isEmpty(config.ffmpeg) ? config.ffmpeg : "未指定"}</span>`,
        SettingButton("选择ffmpeg", "config-ffmpeg-select")
      ),
      SettingItem(
        "",
        null,
        SettingButton("保存", "config-ob11-save", "primary")
      )
    ]),
    SettingList([
      SettingItem(
        "接收戳一戳消息, 暂时只支持Windows版的LLOneBot",
        `重启QQ后生效，如果导致QQ崩溃请勿开启此项`,
        SettingSwitch("enablePoke", config.enablePoke)
      ),
      SettingItem(
        "使用 Base64 编码获取文件",
        "开启后，调用 /get_image、/get_record 时，获取不到 url 时添加一个 Base64 字段",
        SettingSwitch("enableLocalFile2Url", config.enableLocalFile2Url)
      ),
      SettingItem(
        "调试模式",
        "开启后上报信息会添加 raw 字段以附带原始信息",
        SettingSwitch("debug", config.debug)
      ),
      SettingItem(
        "上报 Bot 自身发送的消息",
        "上报 event 为 message_sent",
        SettingSwitch("reportSelfMessage", config.reportSelfMessage)
      ),
      SettingItem(
        "自动删除收到的文件",
        "在收到文件后的指定时间内删除该文件",
        SettingSwitch("autoDeleteFile", config.autoDeleteFile, { "control-display-id": "config-auto-delete-file-second" })
      ),
      SettingItem(
        "自动删除文件时间",
        "单位为秒",
        `<div class="q-input"><input class="q-input__inner" data-config-key="autoDeleteFileSecond" type="number" min="1" value="${config.autoDeleteFileSecond}" placeholder="${config.autoDeleteFileSecond}" /></div>`,
        "config-auto-delete-file-second",
        config.autoDeleteFile
      ),
      SettingItem(
        "写入日志",
        `将日志文件写入插件的数据文件夹`,
        SettingSwitch("log", config.log)
      ),
      SettingItem(
        "日志文件目录",
        `${window.LiteLoader.plugins["LLOneBot"].path.data}`,
        SettingButton("打开", "config-open-log-path")
      )
    ]),
    SettingList([
      SettingItem(
        "GitHub 仓库",
        `https://github.com/LLOneBot/LLOneBot`,
        SettingButton("点个星星", "open-github")
      ),
      SettingItem(
        "LLOneBot 文档",
        `https://llonebot.github.io/`,
        SettingButton("看看文档", "open-docs")
      ),
      SettingItem(
        "Telegram 群",
        `https://t.me/+nLZEnpne-pQ1OWFl`,
        SettingButton("进去逛逛", "open-telegram")
      ),
      SettingItem(
        "QQ 群",
        `545402644`,
        SettingButton("我要进去", "open-qq-group")
      )
    ]),
    "</div>"
  ].join(""), "text/html");
  doc.querySelector("#open-github").addEventListener("click", () => {
    window.LiteLoader.api.openExternal("https://github.com/LLOneBot/LLOneBot");
  });
  doc.querySelector("#open-telegram").addEventListener("click", () => {
    window.LiteLoader.api.openExternal("https://t.me/+nLZEnpne-pQ1OWFl");
  });
  doc.querySelector("#open-qq-group").addEventListener("click", () => {
    window.LiteLoader.api.openExternal("https://qm.qq.com/q/bDnHRG38aI");
  });
  doc.querySelector("#open-docs").addEventListener("click", () => {
    window.LiteLoader.api.openExternal("https://llonebot.github.io/");
  });
  const buildHostListItem = (type, host, index, inputAttrs = {}) => {
    const dom = {
      container: document.createElement("setting-item"),
      input: document.createElement("input"),
      inputContainer: document.createElement("div"),
      deleteBtn: document.createElement("setting-button")
    };
    dom.container.classList.add("setting-host-list-item");
    dom.container.dataset.direction = "row";
    Object.assign(dom.input, inputAttrs);
    dom.input.classList.add("q-input__inner");
    dom.input.type = "url";
    dom.input.value = host;
    dom.input.addEventListener("input", () => {
      ob11Config[type][index] = dom.input.value;
    });
    dom.inputContainer.classList.add("q-input");
    dom.inputContainer.appendChild(dom.input);
    dom.deleteBtn.innerHTML = "删除";
    dom.deleteBtn.dataset.type = "secondary";
    dom.deleteBtn.addEventListener("click", () => {
      ob11Config[type].splice(index, 1);
      initReverseHost(type);
    });
    dom.container.appendChild(dom.inputContainer);
    dom.container.appendChild(dom.deleteBtn);
    return dom.container;
  };
  const buildHostList = (hosts, type, inputAttr = {}) => {
    const result = [];
    hosts.forEach((host, index) => {
      result.push(buildHostListItem(type, host, index, inputAttr));
    });
    return result;
  };
  const addReverseHost = (type, doc2 = document, inputAttr = {}) => {
    const hostContainerDom = doc2.body.querySelector(`#config-ob11-${type}-list`);
    hostContainerDom.appendChild(buildHostListItem(type, "", ob11Config[type].length, inputAttr));
    ob11Config[type].push("");
  };
  const initReverseHost = (type, doc2 = document) => {
    const hostContainerDom = doc2.body.querySelector(`#config-ob11-${type}-list`);
    [...hostContainerDom.childNodes].forEach((dom) => dom.remove());
    buildHostList(ob11Config[type], type).forEach((dom) => {
      hostContainerDom.appendChild(dom);
    });
  };
  initReverseHost("httpHosts", doc);
  initReverseHost("wsHosts", doc);
  doc.querySelector("#config-ob11-httpHosts-add").addEventListener("click", () => addReverseHost("httpHosts", document, { "placeholder": "如：http://127.0.0.1:5140/onebot" }));
  doc.querySelector("#config-ob11-wsHosts-add").addEventListener("click", () => addReverseHost("wsHosts", document, { "placeholder": "如：ws://127.0.0.1:5140/onebot" }));
  doc.querySelector("#config-ffmpeg-select").addEventListener("click", () => {
    window.llonebot.selectFile().then((path) => {
      if (!isEmpty(path)) {
        setConfig("ffmpeg", path);
        document.querySelector("#config-ffmpeg-path-text").innerHTML = path;
      }
    });
  });
  doc.querySelector("#config-open-log-path").addEventListener("click", () => {
    window.LiteLoader.api.openPath(window.LiteLoader.plugins["LLOneBot"].path.data);
  });
  doc.querySelectorAll("setting-switch[data-config-key]").forEach((dom) => {
    dom.addEventListener("click", () => {
      const active = dom.getAttribute("is-active") === null;
      setConfig(dom.dataset.configKey, active);
      if (active)
        dom.setAttribute("is-active", "");
      else
        dom.removeAttribute("is-active");
      if (!isEmpty(dom.dataset.controlDisplayId)) {
        const displayDom = document.querySelector(`#${dom.dataset.controlDisplayId}`);
        if (active)
          displayDom.removeAttribute("is-hidden");
        else
          displayDom.setAttribute("is-hidden", "");
      }
    });
  });
  doc.querySelectorAll("setting-item .q-input input.q-input__inner[data-config-key]").forEach((dom) => {
    dom.addEventListener("input", () => {
      const Type = dom.getAttribute("type");
      const configKey = dom.dataset.configKey;
      const configValue = Type === "number" ? parseInt(dom.value) >= 1 ? parseInt(dom.value) : 1 : dom.value;
      setConfig(configKey, configValue);
    });
  });
  doc.querySelectorAll("setting-select").forEach((dom) => {
    dom.addEventListener("selected", (e) => {
      const configKey = dom.dataset.configKey;
      const configValue = e.detail.value;
      setConfig(configKey, configValue);
    });
  });
  doc.querySelector("#config-ob11-save").addEventListener("click", () => {
    config.ob11 = ob11Config;
    window.llonebot.setConfig(config);
    alert("保存成功");
  });
  doc.body.childNodes.forEach((node) => {
    view.appendChild(node);
  });
}
function init() {
}
if (location.hash === "#/blank") {
  window.navigation.addEventListener("navigatesuccess", init, { once: true });
}
export {
  onSettingWindowCreated
};
